	clear all
	clc
	% EXAMPLE 5.22 C
	wcT = 0.4*pi;	wsT = 0.45*pi;	dc = 0.01; ds = 0.01;
	N = 80;	M = N/2+1;	m = 1:M;	t = 1;
	Kp = 200;  Ks = 400; 
	wT = [linspace(0, wcT, Kp) linspace(wsT, pi, Ks)];
	D = [ones(1, Kp) zeros(1, Ks)];
	efix = [dc*ones(1, Kp) ds*ones(1, Ks)];
	A = TRIGMAT(t, m, wT);	A = [A' -TRIGMAT(t, m, wT)']';
	b = [D+efix -D+efix]';	c = zeros(1, M)';
	S = INT2MAT(t, m, wsT, pi);
	% x = qp(2*S, c, A, b); 	% OLD version
	x = quadprog(2*S, c, A, b);
	h = [0.5*fliplr(x(2:M)') x(1) 0.5*x(2:M)'];		
	subplot('position', [0.1 0.4 0.86 0.5]);		 
	wT = linspace(0, pi, 2000);	H = freqz(h, 1, wT);
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
 	axes('position',[0.63 0.7 0.30 0.12]);
	wT = linspace(0, wcT, 2000);	H = freqz(h, 1, wT);
	PLOT_MAG_Z_LS(wT, H, 0.99, 1.01, 'H')
	
